unit Blah;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Ohmap, Ohmstuff, StdCtrls, ExtCtrls, Menus, clb, Aboutie,
  Blocked, Imprtdlg;

type
  TMainForm = class(TForm)
    IconDisplay: TImage;
    IconName: TEdit;
    Label1: TLabel;
    PrevButton: TButton;
    NextButton: TButton;
    Bevel1: TBevel;
    MainMenu1: TMainMenu;
    File2: TMenuItem;
    Exit1: TMenuItem;
    N2: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    OpenDatasetDialog: TOpenDialog;
    SaveDatasetDialog: TSaveDialog;
    Label2: TLabel;
    OpenBitmap1: TMenuItem;
    Help1: TMenuItem;
    NoHelpForYouMyPrettyMuwahaha1: TMenuItem;
    N3: TMenuItem;
    AboutIconEditor1: TMenuItem;
    NewButton: TButton;
    Edit1: TMenuItem;
    Label4: TLabel;
    RecordCounter: TEdit;
    AttributesCheckList: TCheckListBox;
    OpenBitmapDialog: TOpenDialog;
    Label3: TLabel;
    Label5: TLabel;
    Width: TLabel;
    Height: TLabel;
    DeleteItem1: TMenuItem;
    AlternateIconCombo: TComboBox;
    Label6: TLabel;
    MassBitmapImport1: TMenuItem;
    Button1: TButton;
    Bevel2: TBevel;
    ImportIconsDlg: TPyroImportDialog;
    procedure PrevButtonClick(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure UpdateSet;
    procedure Save1Click(Sender: TObject);
    procedure SaveAs(Sender:TObject);
    procedure DoInitialStuff(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure OpenBitmap1Click(Sender: TObject);
    procedure NewButtonClick(Sender: TObject);
    procedure updateflags(Sender: TObject);
    procedure AboutIconEditor1Click(Sender: TObject);
    procedure DeleteItem1Click(Sender: TObject);
    procedure controlswitch(state:Boolean);
    function Setloaded:Boolean;
    procedure New1Click(Sender: TObject);
    procedure MassBitmapImport1Click(Sender: TObject);
    procedure UpdateNom(Sender: TObject);
    procedure updateAssoc(Sender: TObject);
    procedure cleanup(Sender: TObject; var CanClose: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  function GetFileName(name:string):string;
var
  MainForm: TMainForm;
  iconlist:TMapIconList;
  iconindex:Integer;
  blocklist:TBlockDefList;
  Loadedfile:String;
  DataChanged:Boolean;
  Counter:TCounter;

implementation

{$R *.DFM}
uses
    frameld;


{
 This does all the initialization that can't be done in the init section.
}
procedure TMainForm.DoInitialStuff(Sender: TObject);
var
path:String;
begin
     RecordCounter.text:='0 of 0';
     try
        AlternateIconCombo.Items.AddObject('None',TObject(-1));
        iconlist:=TMapIconList.create;
        blocklist:=TBlockDefList.create;
        Counter:=TCounter.Create;
        controlswitch(false);
        path:=ExtractFilePath(Application.Exename);
        AttributesCheckList.items.loadfromfile(path+'iattrib.txt');
     except
           on EFOpenError do
           Application.MessageBox('Unable to open attribute names: Using defaults.','Icon Editor Error',0);
     end;
end;


procedure TMainForm.cleanup(Sender: TObject; var CanClose: Boolean);
var
   dialog:Integer;
begin
     if DataChanged then begin
        dialog:=Application.MessageBox('The data has been altered. Save now?','Save Now?',mb_Yesnocancel);
        if dialog=IDYES then
           Save1Click(Sender);
        if dialog=IDCANCEL then begin
           CanClose:=False;
           Exit;
        end;
     end;
     iconlist.free;
     blocklist.free;
end;

function GetFileName(name:string):String;
var
a:Integer;
begin
     a:=Pos('.',name);
     result:=Copy(name,0,a-1);
end;

procedure TMainForm.PrevButtonClick(Sender: TObject);
begin
     if iconindex>0 then begin
        iconindex:=iconindex-1;
        UpdateSet;
     end;
end;

procedure TMainForm.NextButtonClick(Sender: TObject);
begin
     if iconindex<(iconlist.count-1) then begin
        iconindex:=iconindex+1;
        UpdateSet;
     end;
end;

procedure TMainForm.NewButtonClick(Sender: TObject);
var
icon:TMapIcon;
begin
     if Setloaded=false then begin
        New1Click(Sender);
        Exit;
     end;
     {Creates a new icon, etc..}
     icon:=TMapIcon.create;
     icon.image.Assign(TMapIcon(iconlist.items[iconindex]).image);
     icon.name:='New Icon';
     AlternateIconCombo.Items.AddObject(icon.name,TObject(icon.id));
     AlternateIconCombo.Itemindex:=0;
     icon.Attributes:=0;
     icon.ID:=Counter.NewID;
     iconindex:=iconlist.add(icon);
     updateset;
     datachanged:=True;
end;

procedure TMainForm.Open1Click(Sender: TObject);
var
a:Integer;
id,dlg,high:Longint;
name:String;
begin
     if OpenDatasetDialog.execute then begin
        if iconlist.count>0 then begin
           dlg:=Application.Messagebox('Save current set first?','Hmm?',mb_YesNoCancel);
           if dlg=IDYES then Save1Click(Sender)
           else if dlg=IDCANCEL then Exit;
        end;
        iconlist.clear;
        try
           iconlist.loadfromfile(OpenDatasetDialog.filename);
           iconindex:=0;
           updateset;
           Loadedfile:=OpenDatasetDialog.filename;
           controlswitch(true);
           high:=0;
           AlternateIconCombo.Items.Clear;
           AlternateIconCombo.Items.AddObject('None',TObject(-1));
           for a:=0 to iconlist.count-1 do begin
               id:=TMapIcon(iconlist.items[a]).id;
               if id>high then
                  high:=id;
               name:=TMapIcon(iconlist.items[a]).name;
               AlternateIconCombo.Items.AddObject(TMapIcon(iconlist.items[a]).name,TObject(TMapIcon(iconlist.items[a]).ID));
           end;
           Counter.Highest:=high;
           name:=GetFileName(loadedfile)+'.blk';
           if FileExists(name) then begin
              blocklist.loadfromfile(name);
           end;
        except
              on EFOpenError do
              begin
                   Application.MessageBox('Unable to open Icon Data Set file.','Load Error',0);
              end;
        end;
     end;
end;

{
    This should be the main refresh routine, that almost all of the others call..
}
procedure TMainForm.UpdateSet;
var
a:Integer;
alt:Longint;
begin
     IconDisplay.picture.bitmap:=TMapIcon(iconlist.items[iconindex]).image;
     IconName.text:=TMapIcon(iconlist.items[iconindex]).name;
     RecordCounter.Text:=IntToStr(iconindex+1)+' of '+IntToStr(iconlist.count);
     for a:=0 to AlternateIconCombo.items.count-1 do begin
         alt:=TMapIcon(iconlist.items[iconindex]).Alternate;
         if Longint(AlternateIconCombo.Items.Objects[a])=TMapIcon(iconlist.items[iconindex]).Alternate then begin
            AlternateIconCombo.ItemIndex:=a;
            Break;
         end;
     end;
     width.caption:=IntToStr(TMapIcon(iconlist.items[iconindex]).image.width);
     height.caption:=IntToStr(TMapIcon(iconlist.items[iconindex]).image.height);
     AttributesCheckList.flags:=TMapIcon(iconlist.items[iconindex]).Attributes;
     AttributesCheckList.repaint;
end;

procedure TMainForm.Save1Click(Sender: TObject);
var
name:String;
begin
     if Pointer(iconlist)<>nil then begin
        if loadedfile<>'' then begin
           DataChanged:=False;
           try
              name:=GetFileName(loadedfile)+'.blk';
              iconlist.savetofile(Loadedfile);
              if blocklist.count>0 then
                 blocklist.savetofile(name);
           except
                 Application.MessageBox('Unable to save Icon Data Set file.','Save Error',0);
           end;
        end
        else
        begin
            SaveAs(Sender);
        end;
     end;
end;

procedure TMainForm.SaveAs(Sender:TObject);
var
name:string;
begin
     if Pointer(iconlist)<>nil then begin
        SaveDatasetDialog.execute;
        if SaveDatasetDialog.filename<>'' then begin
           try
              name:=GetFileName(SaveDatasetDialog.filename)+'.blk';
              iconlist.savetofile(SaveDatasetDialog.filename);
              if blocklist.count>0 then
                 blocklist.savetofile(name);
              DataChanged:=False;
              loadedfile:=SaveDatasetDialog.filename;
              UpdateSet;
           except
                 Application.MessageBox('Unable to save Icon Data Set file.','Save Error',0);
           end;
        end;
     end;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
     Application.Terminate;
end;

function TMainForm.Setloaded:Boolean;
begin
     if iconlist.count>0 then
        result:=True
     else
         result:=False;
end;

procedure TMainForm.OpenBitmap1Click(Sender: TObject);
var
icon:TMapIcon;
dialog:Integer;
begin
     if Setloaded=true then begin
        OpenBitMapDialog.filename:='';
        OpenBitmapDialog.execute;
        if OpenBitmapDialog.filename<>'' then begin
           dialog:=Application.Messagebox('Overwrite current bitmap? (No Creates New Icon)','Icon Editor Query',3);
           if dialog=IDNO then begin
              icon:=TMapIcon.create;
              icon.name:='New Icon';
              icon.id:=Counter.NewID;
              iconlist.add(icon);
              iconindex:=iconlist.count-1;
              AlternateIconCombo.Items.Addobject(icon.name,TObject(icon.ID));
           end
           else if dialog=IDYES then begin
                icon:=iconlist.items[iconindex];
           end
           else if dialog=IDCANCEL then
                Exit;

           try
              icon.image.loadfromfile(OpenBitmapDialog.filename);
              UpdateSet;
           except
                 on EFOpenError do begin
                    Application.Messagebox('Unable to open bitmap file.','Load Error',0);
                    if dialog=IDNO then begin
                       AlternateIconCombo.Items.Delete(iconindex+1);
                       iconlist.delete(iconindex);
                       icon.free;
                       iconindex:=0;
                    end;
                 end;
                 on EInvalidGraphic do begin
                    Application.Messagebox('Invalid Graphic.','Error',0);
                    iconlist.delete(iconindex);
                    icon.free;
                    iconindex:=0;
                 end;
           end;
        end;
     end;
end;

procedure TMainForm.updateflags(Sender: TObject);
begin
     TMapIcon(iconlist.items[iconindex]).Attributes:=AttributesCheckList.flags;
     datachanged:=true;
end;

procedure TMainForm.AboutIconEditor1Click(Sender: TObject);
begin
     aboutbox.showmodal;
end;

{
This procedure turns the controls on and off
}
procedure TMainForm.controlswitch(state:Boolean);
begin
     IconName.enabled:=state;
     AttributesCheckList.enabled:=state;
     NextButton.enabled:=state;
     PrevButton.enabled:=state;
     RecordCounter.enabled:=state;
     AlternateIconCombo.enabled:=state;
     SaveAs1.Enabled:=state;
     Save1.Enabled:=state;
     OpenBitmap1.Enabled:=state;
     {MassBitmapImport1.enabled:=state;}
end;

procedure TMainForm.DeleteItem1Click(Sender: TObject);
begin
     if setloaded=true then begin
        if iconlist.count>0 then begin
          if Application.Messagebox('Delete current icon?','Delete?',mb_yesno)=IDYES then begin
             AlternateIconCombo.items.Delete(iconindex+1);
             TMapIcon(iconlist.items[iconindex]).free;
             iconlist.delete(iconindex);
             if iconlist.count=0 then begin
                controlswitch(False);
             end
             else if iconindex>0 then
                     iconindex:=iconindex-1;
             Datachanged:=true;
             Updateset;
          end;
        end;
     end;

end;

{
 This procedure creates a new set, prompting the user for the first icon.
}
procedure TMainForm.New1Click(Sender: TObject);
var
dialog:Integer;
icon:TMapicon;
begin
     if setloaded=true then begin
        dialog:=Application.Messagebox('Overwrite current icon set?','Overwrite?',mb_YesNo);
        if dialog=IDYES then begin
           iconlist.clear;
        end;
        if dialog=IDNO then
           Exit;
     end;
     Application.Messagebox('Now you must select your first icon bitmap for the new set.','First Icon',0);
     openbitmapdialog.execute;
     if openbitmapdialog.filename<>'' then begin
        try
           icon:=TMapicon.create;
           iconlist:=TMapIconList.create;
           icon.name:='New Icon';
           icon.id:=Counter.newid;
           iconlist.add(icon);
           iconindex:=0;
           icon.image.loadfromfile(openbitmapdialog.filename);
           AlternateIconCombo.Items.Addobject(icon.name,TObject(icon.ID));
           controlswitch(true);
           updateset;
           datachanged:=True;
        except
              on EInvalidGraphic do begin
                 Application.Messagebox('Invalid graphic.','Error',0);
                 iconlist.clear;
              end;
              on EFOpenError do begin
                 Application.Messagebox('Unable to open bitmap file.','Load Error',0);
                 iconlist.clear;
              end;
        end;
     end;
end;

procedure TMainForm.MassBitmapImport1Click(Sender: TObject);
var
files:TStringList;
icon:TMapIcon;
a,place:Integer;
begin
     files:=ImportIconsDlg.Execute;
     if files<>nil then begin
        place:=PlaceFrame.Showmodal;
        if place<>IDCANCEL then begin
           try
              for a:=0 to files.count-1 do begin
                  icon:=TMapIcon.Create;
                  icon.name:='New Icon '+IntToStr(a);
                  icon.id:=counter.newid;
                  icon.image:=TBitMap.Create;
                  icon.image.loadfromfile(files.strings[a]);
                  iconlist.add(icon);
                  AlternateIconCombo.Items.Addobject(icon.name,TObject(icon.ID));
              end;
              updateset;
              controlswitch(true);
              datachanged:=true;
           finally
                  files.free;
           end;
        end;
     end;
end;

procedure TMainForm.UpdateNom(Sender: TObject);
var
a,id:Longint;
begin
     DataChanged:=True;
     TMapIcon(iconlist.items[iconindex]).name:=IconName.text;
     for a:=0 to AlternateIconCombo.items.count-1 do begin
         id:=LongInt(AlternateIconCombo.items.objects[a]);
         if id=TMapIcon(iconlist.items[iconindex]).id then begin
            AlternateIconCombo.items[a]:=IconName.text;
            Exit;
         end;
     end;
end;

procedure TMainForm.updateAssoc(Sender: TObject);
begin
     DataChanged:=True;
     TMapIcon(iconlist.items[iconindex]).Alternate:=Longint(AlternateIconCombo.Items.Objects[AlternateIconCombo.ItemIndex]);
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
     if iconlist.count>0 then
        BlockEdForm.Show
     else
         Application.Messagebox('Load or create an icon set first.','Hey!',0);
end;

initialization

DataChanged:=False;

end.
